package ch.frankel.blog.p6spy.model;

import static javax.persistence.TemporalType.DATE;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;

/**
 * A simple person.
 * 
 * @author <a href="http://blog.frankel.ch/">Nicolas Frankel</a>
 */
@Entity
@Table(name = "T_PERSON")
public class Person {

    private Long id;

    private String firstName;

    private String lastName;

    private Date birthDate;

    @Temporal(DATE)
    @Column(name = "PER_D_BIRTH_DATE")
    public Date getBirthDate() {

        return birthDate;
    }

    @Column(name = "PER_T_FIRST_NAME")
    public String getFirstName() {

        return firstName;
    }

    @Id
    @Column(name = "PER_N_ID")
    public Long getId() {

        return id;
    }

    @Column(name = "PER_T_LAST_NAME")
    public String getLastName() {

        return lastName;
    }

    public void setBirthDate(Date aBirthDate) {

        birthDate = aBirthDate;
    }

    public void setFirstName(String aFirstName) {

        firstName = aFirstName;
    }

    public void setId(Long aId) {

        id = aId;
    }

    public void setLastName(String aLastName) {

        lastName = aLastName;
    }
}
